const http = require('http')
const fs = require('fs')
const path = require('path')

const port = Number(process.env.BACKEND_PORT || 2738)
const distDir = path.join(__dirname, '..', 'hls-player', 'dist')

const sendJson = (res, statusCode, payload) => {
  const body = JSON.stringify(payload)
  res.writeHead(statusCode, {
    'Content-Type': 'application/json; charset=utf-8',
    'Content-Length': Buffer.byteLength(body),
  })
  res.end(body)
}

const sendFile = (res, filePath) => {
  const stream = fs.createReadStream(filePath)
  stream.on('error', () => {
    sendJson(res, 404, { error: 'not_found' })
  })
  stream.pipe(res)
}

const server = http.createServer((req, res) => {
  if (!req.url || req.method !== 'GET') {
    sendJson(res, 405, { error: 'method_not_allowed' })
    return
  }

  if (req.url === '/health') {
    sendJson(res, 200, { status: 'ok' })
    return
  }

  if (fs.existsSync(distDir)) {
    const requestPath = req.url.split('?')[0]
    const resolvedPath = path.join(
      distDir,
      requestPath === '/' ? 'index.html' : requestPath,
    )

    if (resolvedPath.startsWith(distDir) && fs.existsSync(resolvedPath)) {
      sendFile(res, resolvedPath)
      return
    }

    const fallback = path.join(distDir, 'index.html')
    if (fs.existsSync(fallback)) {
      sendFile(res, fallback)
      return
    }
  }

  sendJson(res, 404, { error: 'not_found' })
})

server.listen(port, () => {
  // eslint-disable-next-line no-console
  console.log(`Backend server listening on http://127.0.0.1:${port}`)
})
