#!/usr/bin/env bash
set -euo pipefail

ROOT_DIR=$(cd "$(dirname "$0")" && pwd)
ENV_FILE="$ROOT_DIR/hls-player/.env"

FRONTEND_PORT=${FRONTEND_PORT:-7594}
BACKEND_PORT=${BACKEND_PORT:-2738}
FRONTEND_HOST=${FRONTEND_HOST:-0.0.0.0}
BACKEND_HOST=${BACKEND_HOST:-0.0.0.0}

if [ -f "$ENV_FILE" ]; then
  set -a
  . "$ENV_FILE"
  set +a
fi

FRONTEND_PUBLIC_URL=${FRONTEND_PUBLIC_URL:-"http://127.0.0.1:${FRONTEND_PORT}"}
BACKEND_PUBLIC_URL=${BACKEND_PUBLIC_URL:-"http://127.0.0.1:${BACKEND_PORT}"}

if [ ! -x "$ROOT_DIR/hls-player/node_modules/.bin/vite" ]; then
  (cd "$ROOT_DIR/hls-player" && npm install)
fi

if [ ! -x "$ROOT_DIR/backend/node_modules/.bin/nodemon" ]; then
  (cd "$ROOT_DIR/backend" && npm install)
fi

( 
  cd "$ROOT_DIR/backend"
  BACKEND_HOST="$BACKEND_HOST" \
  BACKEND_PORT="$BACKEND_PORT" \
  FRONTEND_URL="$FRONTEND_PUBLIC_URL" \
  npm run dev
) &
BACKEND_PID=$!

(
  cd "$ROOT_DIR/hls-player"
  FRONTEND_PORT="$FRONTEND_PORT" \
  VITE_BACKEND_URL="$BACKEND_PUBLIC_URL" \
  npm run dev -- --host "$FRONTEND_HOST" --port "$FRONTEND_PORT" --strictPort
) &
FRONTEND_PID=$!

cleanup() {
  kill "$FRONTEND_PID" "$BACKEND_PID" 2>/dev/null || true
}
trap cleanup EXIT

wait "$FRONTEND_PID" "$BACKEND_PID"
