# HLS Player Gap Alignment Implementation Plan

> **For Claude:** REQUIRED SUB-SKILL: Use superpowers:executing-plans to implement this plan task-by-task.

**Goal:** Align the current HLS player project with the prompt’s system architecture, network configuration, and orchestration requirements.

**Architecture:** Keep the existing React/Vite frontend on port 7594, add a lightweight Express backend on port 2738 with an optional HLS proxy endpoint, and update dev/prod scripts to orchestrate both services with logging and environment injection. Maintain query parameter compatibility and add responsive embed snippet output.

**Tech Stack:** React 19 + Vite + Tailwind, hls.js + Plyr, Node.js + Express, Vitest, shell scripts.

---

### Task 1: Align URL parameter schema (support ?src & numeric flags)

**Files:**
- Modify: `hls-player/src/lib/configCodec.ts`
- Modify: `hls-player/src/lib/configCodec.test.ts`
- Modify: `hls-player/src/components/EmbedSnippet.tsx`

**Step 1: Write failing tests for new parameter handling**
Add tests to `hls-player/src/lib/configCodec.test.ts` for:
- `src` param as alias for `url`
- `muted=1` / `auto=1` / `controls=0` numeric flag parsing
- backward compatibility with existing `url`/`autoplay`/`muted`

Run: `cd hls-player && npm run test -- src/lib/configCodec.test.ts`
Expected: FAIL due to missing parsing logic

**Step 2: Implement codec support**
Update `decodeConfig` to accept:
- `src` -> `url`
- `auto` -> `autoplay`
- numeric flags (`1`/`0`) and booleans (`true`/`false`)

Update `encodeConfig` to produce canonical params:
- use `src`, `auto`, `muted`, `controls`, `loop` (as 1/0)

**Step 3: Update embed snippet to use new params**
Update `EmbedSnippet` to generate URLs with the canonical params.

**Step 4: Run tests**
Run: `cd hls-player && npm run test -- src/lib/configCodec.test.ts`
Expected: PASS

**Step 5: Commit**
Run: `git add hls-player/src/lib/configCodec.ts hls-player/src/lib/configCodec.test.ts hls-player/src/components/EmbedSnippet.tsx`
Run: `git commit -m "feat: support src/auto param schema"`

---

### Task 2: Responsive embed snippet (16:9 container)

**Files:**
- Modify: `hls-player/src/components/EmbedSnippet.tsx`

**Step 1: Add responsive snippet template**
Update the snippet to include a wrapper div with a 16:9 aspect ratio using CSS (padding-top technique) and an absolutely positioned iframe.

**Step 2: Commit**
Run: `git add hls-player/src/components/EmbedSnippet.tsx`
Run: `git commit -m "feat: add responsive embed snippet"`

---

### Task 3: Express backend with optional CORS proxy

**Files:**
- Create: `backend/package.json`
- Create: `backend/index.js`
- Create: `backend/proxy.js`
- Create: `backend/README.md`

**Step 1: Add backend package.json**
Include dependencies: `express`, `http-proxy-middleware` (or `undici`), `cors`.
Add scripts: `dev` (nodemon or node --watch), `start`.

**Step 2: Implement backend server**
- Serve static `hls-player/dist` on port 2738
- Add `/health` endpoint
- Add `/proxy?url=...` endpoint that forwards HLS requests with CORS headers
- Validate URL protocol and basic allowlist to avoid SSRF risk

**Step 3: Add proxy helper**
Put proxy logic in `backend/proxy.js` to keep server clean.

**Step 4: Commit**
Run: `git add backend/*`
Run: `git commit -m "feat: add express backend with hls proxy"`

---

### Task 4: Orchestration scripts alignment (dev/prod)

**Files:**
- Modify: `dev.sh`
- Modify: `prod.sh`
- Create: `logs/.gitkeep`

**Step 1: dev.sh updates**
- Ensure frontend on 7594 and backend on 2738
- Add backend hot reload (`node --watch` or `nodemon`)
- Inject `FRONTEND_URL` and `BACKEND_URL` env vars

**Step 2: prod.sh updates**
- Build frontend
- Serve frontend via `serve` or backend static handler on 7594
- Ensure backend on 2738
- Log to `/logs/prod.log`

**Step 3: Commit**
Run: `git add dev.sh prod.sh logs/.gitkeep`
Run: `git commit -m "chore: align dev/prod orchestration"`

---

### Task 5: Documentation alignment

**Files:**
- Modify: `hls-player/README.md`

**Step 1: Update README**
Add:
- Port mapping (7594/2738)
- Query params (`src`, `auto`, `muted`, `controls`, `loop`)
- Proxy endpoint usage
- Embed snippet example (responsive wrapper)

**Step 2: Commit**
Run: `git add hls-player/README.md`
Run: `git commit -m "docs: update ports and embed params"`

---

### Task 6: Verification

**Step 1: Run tests**
Run: `cd hls-player && npm run test`
Expected: PASS

**Step 2: Build frontend**
Run: `cd hls-player && npm run build`
Expected: PASS

**Step 3: Quick manual smoke (optional)**
Run: `./dev.sh` and verify:
- frontend on 7594
- backend on 2738
- `/health` returns ok
- `/proxy?url=...` responds

**Step 4: Commit (if any changes)**
If verification changes require code updates, commit them with a clear message.
