/**
 * ### The `@exodus/bytes` package consists of submodules, there is no single export.
 * Import specific submodules instead.
 *
 * See [README](https://github.com/ExodusOSS/bytes/blob/main/README.md).
 *
 * Example:
 * ```js
 * import { fromHex, toHex } from '@exodus/bytes/hex.js'
 * import { fromBase64, toBase64, fromBase64url, toBase64url, fromBase64any } from '@exodus/bytes/base64.js'
 * import { fromBase32, toBase32, fromBase32hex, toBase32hex } from '@exodus/bytes/base32.js'
 * import { fromBase58, toBase58, fromBase58xrp, toBase58xrp } from '@exodus/bytes/base58.js'
 * import { fromBech32, toBech32, fromBech32m, toBech32m, getPrefix } from '@exodus/bytes/bech32.js'
 * import { fromBigInt, toBigInt } from '@exodus/bytes/bigint.js'
 *
 * import { utf8fromString, utf8toString, utf8fromStringLoose, utf8toStringLoose } from '@exodus/bytes/utf8.js'
 * import { utf16fromString, utf16toString, utf16fromStringLoose, utf16toStringLoose } from '@exodus/bytes/utf16.js'
 * import {
 *   createSinglebyteDecoder, createSinglebyteEncoder,
 *   windows1252toString, windows1252fromString,
 *   latin1toString, latin1fromString } from '@exodus/bytes/single-byte.js'
 * import { createMultibyteDecoder, createMultibyteEncoder } from '@exodus/bytes/multi-byte.js'
 *
 * import {
 *   fromBase58check, toBase58check,
 *   fromBase58checkSync, toBase58checkSync,
 *   makeBase58check } from '@exodus/bytes/base58check.js'
 * import { fromWifString, toWifString, fromWifStringSync, toWifStringSync } from '@exodus/bytes/wif.js'
 *
 * // All encodings from the WHATWG Encoding spec
 * import { TextDecoder, TextEncoder, TextDecoderStream, TextEncoderStream } from '@exodus/bytes/encoding.js'
 * import { getBOMEncoding, legacyHookDecode, labelToName, normalizeEncoding } from '@exodus/bytes/encoding.js'
 *
 * // Omits legacy multi-byte decoders to save bundle size
 * import { TextDecoder, TextEncoder, TextDecoderStream, TextEncoderStream } from '@exodus/bytes/encoding-lite.js'
 * import { getBOMEncoding, legacyHookDecode, labelToName, normalizeEncoding } from '@exodus/bytes/encoding-lite.js'
 *
 * // In browser bundles, uses built-in TextDecoder / TextEncoder to save bundle size
 * import { TextDecoder, TextEncoder, TextDecoderStream, TextEncoderStream } from '@exodus/bytes/encoding-browser.js'
 * import { getBOMEncoding, legacyHookDecode, labelToName, normalizeEncoding } from '@exodus/bytes/encoding-browser.js'
 * ```
 */
declare module "@exodus/bytes" {}
