"use strict";
// autogenerated - 2026-01-06

module.exports = new Map([
  [
    "-webkit-border-after-color",
    null
  ],
  [
    "-webkit-border-before-color",
    null
  ],
  [
    "-webkit-border-end-color",
    null
  ],
  [
    "-webkit-border-start-color",
    null
  ],
  [
    "-webkit-column-rule-color",
    null
  ],
  [
    "-webkit-tap-highlight-color",
    null
  ],
  [
    "-webkit-text-emphasis-color",
    null
  ],
  [
    "-webkit-text-fill-color",
    {
      "name": "-webkit-text-fill-color",
      "href": "https://compat.spec.whatwg.org/#propdef--webkit-text-fill-color",
      "initial": "currentcolor",
      "appliesTo": "all elements",
      "inherited": "yes",
      "percentages": "N/A",
      "computedValue": "an RGBA color",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "media": "visual",
      "styleDeclaration": [
        "-webkit-text-fill-color",
        "WebkitTextFillColor",
        "webkitTextFillColor"
      ],
      "syntax": "<color>",
      "extended": []
    }
  ],
  [
    "-webkit-text-stroke-color",
    {
      "name": "-webkit-text-stroke-color",
      "href": "https://compat.spec.whatwg.org/#propdef--webkit-text-stroke-color",
      "initial": "currentcolor",
      "appliesTo": "all elements",
      "inherited": "yes",
      "percentages": "N/A",
      "computedValue": "an RGBA color",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "media": "visual",
      "styleDeclaration": [
        "-webkit-text-stroke-color",
        "WebkitTextStrokeColor",
        "webkitTextStrokeColor"
      ],
      "syntax": "<color>",
      "extended": []
    }
  ],
  [
    "background",
    {
      "name": "background",
      "href": "https://drafts.csswg.org/css-backgrounds-4/#propdef-background",
      "initial": "see individual properties",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "see individual properties",
      "computedValue": "see individual properties",
      "animationType": "see individual properties",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "background"
      ],
      "syntax": "<bg-layer>#? , <final-bg-layer>",
      "extended": []
    }
  ],
  [
    "background-attachment",
    {
      "name": "background-attachment",
      "href": "https://drafts.csswg.org/css-backgrounds-4/#propdef-background-attachment",
      "initial": "scroll",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "list, each item the keyword as specified",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "background-attachment",
        "backgroundAttachment"
      ],
      "syntax": "<attachment>#",
      "extended": []
    }
  ],
  [
    "background-clip",
    {
      "name": "background-clip",
      "href": "https://drafts.csswg.org/css-backgrounds-4/#propdef-background-clip",
      "initial": "border-box",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "animationType": "repeatable list",
      "styleDeclaration": [
        "background-clip",
        "backgroundClip"
      ],
      "syntax": "<bg-clip>#",
      "extended": []
    }
  ],
  [
    "background-color",
    {
      "name": "background-color",
      "href": "https://drafts.csswg.org/css-backgrounds-4/#propdef-background-color",
      "initial": "transparent",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "computed color",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value",
      "styleDeclaration": [
        "background-color",
        "backgroundColor"
      ],
      "syntax": "<color>",
      "extended": []
    }
  ],
  [
    "background-image",
    {
      "name": "background-image",
      "href": "https://drafts.csswg.org/css-backgrounds-4/#propdef-background-image",
      "initial": "none",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "list, each item either an <image> or the keyword none",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "background-image",
        "backgroundImage"
      ],
      "syntax": "<bg-image>#",
      "extended": []
    }
  ],
  [
    "background-origin",
    {
      "name": "background-origin",
      "href": "https://drafts.csswg.org/css-backgrounds-4/#propdef-background-origin",
      "initial": "padding-box",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "list, each item a keyword as specified",
      "canonicalOrder": "per grammar",
      "animationType": "repeatable list",
      "styleDeclaration": [
        "background-origin",
        "backgroundOrigin"
      ],
      "syntax": "<visual-box>#",
      "extended": []
    }
  ],
  [
    "background-position",
    {
      "name": "background-position",
      "href": "https://drafts.csswg.org/css-backgrounds-4/#propdef-background-position",
      "initial": "0% 0%",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "refer to size of background positioning area minus size of background image; see text",
      "computedValue": "a list, each item a pair of offsets (horizontal and vertical) from the top left origin, each offset given as a computed <length-percentage> value",
      "canonicalOrder": "per grammar",
      "animationType": "repeatable list",
      "styleDeclaration": [
        "background-position",
        "backgroundPosition"
      ],
      "syntax": "<bg-position>#",
      "extended": []
    }
  ],
  [
    "background-repeat",
    {
      "name": "background-repeat",
      "href": "https://drafts.csswg.org/css-backgrounds-4/#propdef-background-repeat",
      "initial": "repeat",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "list, each item a pair of keywords, one per dimension",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "background-repeat",
        "backgroundRepeat"
      ],
      "syntax": "<repeat-style>#",
      "extended": []
    }
  ],
  [
    "background-size",
    {
      "name": "background-size",
      "href": "https://drafts.csswg.org/css-backgrounds-4/#propdef-background-size",
      "initial": "auto",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "see text",
      "computedValue": "list, each item a pair of sizes (one per axis) each represented as either a keyword or a computed <length-percentage> value",
      "canonicalOrder": "per grammar",
      "animationType": "repeatable list",
      "styleDeclaration": [
        "background-size",
        "backgroundSize"
      ],
      "syntax": "<bg-size>#",
      "extended": []
    }
  ],
  [
    "border",
    {
      "name": "border",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-border",
      "initial": "see individual properties",
      "appliesTo": "see individual properties",
      "inherited": "see individual properties",
      "percentages": "see individual properties",
      "computedValue": "see individual properties",
      "animationType": "see individual properties",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "border"
      ],
      "syntax": "<line-width> || <line-style> || <color>",
      "extended": []
    }
  ],
  [
    "border-bottom",
    {
      "name": "border-bottom",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-border-bottom",
      "initial": "See individual properties",
      "appliesTo": "all elements except ruby base containers and ruby annotation containers",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "see individual properties",
      "animationType": "see individual properties",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "border-bottom",
        "borderBottom"
      ],
      "syntax": "<line-width> || <line-style> || <color>",
      "extended": []
    }
  ],
  [
    "border-bottom-color",
    {
      "name": "border-bottom-color",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-border-bottom-color",
      "initial": "currentcolor",
      "appliesTo": "all elements except ruby base containers and ruby annotation containers",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "the computed color and/or a one-dimensional image function",
      "canonicalOrder": "per grammar",
      "animationType": "see prose",
      "logicalPropertyGroup": "border-color",
      "styleDeclaration": [
        "border-bottom-color",
        "borderBottomColor"
      ],
      "syntax": "<color> | <image-1D>",
      "extended": []
    }
  ],
  [
    "border-bottom-style",
    {
      "name": "border-bottom-style",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-border-bottom-style",
      "initial": "none",
      "appliesTo": "all elements except ruby base containers and ruby annotation containers",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "specified keyword",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "logicalPropertyGroup": "border-style",
      "styleDeclaration": [
        "border-bottom-style",
        "borderBottomStyle"
      ],
      "syntax": "<line-style>",
      "extended": []
    }
  ],
  [
    "border-bottom-width",
    {
      "name": "border-bottom-width",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-border-bottom-width",
      "initial": "medium",
      "appliesTo": "all elements except ruby base containers and ruby annotation containers",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "absolute length, snapped as a border width; zero if the border style is none or hidden",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value",
      "logicalPropertyGroup": "border-width",
      "styleDeclaration": [
        "border-bottom-width",
        "borderBottomWidth"
      ],
      "syntax": "<line-width>",
      "extended": []
    }
  ],
  [
    "border-collapse",
    {
      "name": "border-collapse",
      "href": "https://drafts.csswg.org/css-tables-3/#propdef-border-collapse",
      "initial": "separate",
      "appliesTo": "table grid boxes",
      "inherited": "yes",
      "percentages": "n/a",
      "computedValue": "specified keyword",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "border-collapse",
        "borderCollapse"
      ],
      "syntax": "separate | collapse",
      "extended": []
    }
  ],
  [
    "border-color",
    {
      "name": "border-color",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-border-color",
      "initial": "see individual properties",
      "appliesTo": "see individual properties",
      "inherited": "see individual properties",
      "percentages": "see individual properties",
      "computedValue": "see individual properties",
      "animationType": "see individual properties",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "border-color",
        "borderColor"
      ],
      "syntax": "[ <color> | <image-1D> ]{1,4}",
      "extended": []
    }
  ],
  [
    "border-left",
    {
      "name": "border-left",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-border-left",
      "initial": "See individual properties",
      "appliesTo": "all elements except ruby base containers and ruby annotation containers",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "see individual properties",
      "animationType": "see individual properties",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "border-left",
        "borderLeft"
      ],
      "syntax": "<line-width> || <line-style> || <color>",
      "extended": []
    }
  ],
  [
    "border-left-color",
    {
      "name": "border-left-color",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-border-left-color",
      "initial": "currentcolor",
      "appliesTo": "all elements except ruby base containers and ruby annotation containers",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "the computed color and/or a one-dimensional image function",
      "canonicalOrder": "per grammar",
      "animationType": "see prose",
      "logicalPropertyGroup": "border-color",
      "styleDeclaration": [
        "border-left-color",
        "borderLeftColor"
      ],
      "syntax": "<color> | <image-1D>",
      "extended": []
    }
  ],
  [
    "border-left-style",
    {
      "name": "border-left-style",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-border-left-style",
      "initial": "none",
      "appliesTo": "all elements except ruby base containers and ruby annotation containers",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "specified keyword",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "logicalPropertyGroup": "border-style",
      "styleDeclaration": [
        "border-left-style",
        "borderLeftStyle"
      ],
      "syntax": "<line-style>",
      "extended": []
    }
  ],
  [
    "border-left-width",
    {
      "name": "border-left-width",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-border-left-width",
      "initial": "medium",
      "appliesTo": "all elements except ruby base containers and ruby annotation containers",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "absolute length, snapped as a border width; zero if the border style is none or hidden",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value",
      "logicalPropertyGroup": "border-width",
      "styleDeclaration": [
        "border-left-width",
        "borderLeftWidth"
      ],
      "syntax": "<line-width>",
      "extended": []
    }
  ],
  [
    "border-right",
    {
      "name": "border-right",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-border-right",
      "initial": "See individual properties",
      "appliesTo": "all elements except ruby base containers and ruby annotation containers",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "see individual properties",
      "animationType": "see individual properties",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "border-right",
        "borderRight"
      ],
      "syntax": "<line-width> || <line-style> || <color>",
      "extended": []
    }
  ],
  [
    "border-right-color",
    {
      "name": "border-right-color",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-border-right-color",
      "initial": "currentcolor",
      "appliesTo": "all elements except ruby base containers and ruby annotation containers",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "the computed color and/or a one-dimensional image function",
      "canonicalOrder": "per grammar",
      "animationType": "see prose",
      "logicalPropertyGroup": "border-color",
      "styleDeclaration": [
        "border-right-color",
        "borderRightColor"
      ],
      "syntax": "<color> | <image-1D>",
      "extended": []
    }
  ],
  [
    "border-right-style",
    {
      "name": "border-right-style",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-border-right-style",
      "initial": "none",
      "appliesTo": "all elements except ruby base containers and ruby annotation containers",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "specified keyword",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "logicalPropertyGroup": "border-style",
      "styleDeclaration": [
        "border-right-style",
        "borderRightStyle"
      ],
      "syntax": "<line-style>",
      "extended": []
    }
  ],
  [
    "border-right-width",
    {
      "name": "border-right-width",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-border-right-width",
      "initial": "medium",
      "appliesTo": "all elements except ruby base containers and ruby annotation containers",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "absolute length, snapped as a border width; zero if the border style is none or hidden",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value",
      "logicalPropertyGroup": "border-width",
      "styleDeclaration": [
        "border-right-width",
        "borderRightWidth"
      ],
      "syntax": "<line-width>",
      "extended": []
    }
  ],
  [
    "border-spacing",
    {
      "name": "border-spacing",
      "href": "https://drafts.csswg.org/css-tables-3/#propdef-border-spacing",
      "initial": "0px 0px",
      "appliesTo": "table grid boxes when border-collapse is separate",
      "inherited": "yes",
      "percentages": "n/a",
      "computedValue": "two absolute lengths",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value",
      "styleDeclaration": [
        "border-spacing",
        "borderSpacing"
      ],
      "syntax": "<length>{1,2}",
      "extended": []
    }
  ],
  [
    "border-style",
    {
      "name": "border-style",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-border-style",
      "initial": "see individual properties",
      "appliesTo": "see individual properties",
      "inherited": "see individual properties",
      "percentages": "see individual properties",
      "computedValue": "see individual properties",
      "animationType": "see individual properties",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "border-style",
        "borderStyle"
      ],
      "syntax": "<'border-top-style'>{1,4}",
      "extended": []
    }
  ],
  [
    "border-top",
    {
      "name": "border-top",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-border-top",
      "initial": "See individual properties",
      "appliesTo": "all elements except ruby base containers and ruby annotation containers",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "see individual properties",
      "animationType": "see individual properties",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "border-top",
        "borderTop"
      ],
      "syntax": "<line-width> || <line-style> || <color>",
      "extended": []
    }
  ],
  [
    "border-top-color",
    {
      "name": "border-top-color",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-border-top-color",
      "initial": "currentcolor",
      "appliesTo": "all elements except ruby base containers and ruby annotation containers",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "the computed color and/or a one-dimensional image function",
      "canonicalOrder": "per grammar",
      "animationType": "see prose",
      "logicalPropertyGroup": "border-color",
      "styleDeclaration": [
        "border-top-color",
        "borderTopColor"
      ],
      "syntax": "<color> | <image-1D>",
      "extended": []
    }
  ],
  [
    "border-top-style",
    {
      "name": "border-top-style",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-border-top-style",
      "initial": "none",
      "appliesTo": "all elements except ruby base containers and ruby annotation containers",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "specified keyword",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "logicalPropertyGroup": "border-style",
      "styleDeclaration": [
        "border-top-style",
        "borderTopStyle"
      ],
      "syntax": "<line-style>",
      "extended": []
    }
  ],
  [
    "border-top-width",
    {
      "name": "border-top-width",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-border-top-width",
      "initial": "medium",
      "appliesTo": "all elements except ruby base containers and ruby annotation containers",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "absolute length, snapped as a border width; zero if the border style is none or hidden",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value",
      "logicalPropertyGroup": "border-width",
      "styleDeclaration": [
        "border-top-width",
        "borderTopWidth"
      ],
      "syntax": "<line-width>",
      "extended": []
    }
  ],
  [
    "border-width",
    {
      "name": "border-width",
      "href": "https://drafts.csswg.org/css-borders-4/#propdef-border-width",
      "initial": "see individual properties",
      "appliesTo": "see individual properties",
      "inherited": "see individual properties",
      "percentages": "see individual properties",
      "computedValue": "see individual properties",
      "animationType": "see individual properties",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "border-width",
        "borderWidth"
      ],
      "syntax": "<'border-top-width'>{1,4}",
      "extended": []
    }
  ],
  [
    "bottom",
    {
      "name": "bottom",
      "href": "https://drafts.csswg.org/css-position-3/#propdef-bottom",
      "initial": "auto",
      "appliesTo": "positioned elements",
      "inherited": "no",
      "percentages": "refer to size of containing block; see prose",
      "computedValue": "the keyword auto or a computed <length-percentage> value",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "logicalPropertyGroup": "inset",
      "styleDeclaration": [
        "bottom"
      ],
      "syntax": "auto | <length-percentage> | <anchor()> | <anchor-size()>",
      "extended": [
        "https://drafts.csswg.org/css-anchor-position-1/"
      ]
    }
  ],
  [
    "clear",
    {
      "name": "clear",
      "href": "https://drafts.csswg.org/css-page-floats-3/#propdef-clear",
      "initial": "none",
      "appliesTo": "block-level elements, floats, regions, pages",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "specified keyword",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "clear"
      ],
      "syntax": "inline-start | inline-end | block-start | block-end | left | right | top | bottom | both-inline | both-block | both | none",
      "extended": []
    }
  ],
  [
    "clip",
    {
      "name": "clip",
      "href": "https://drafts.fxtf.org/css-masking-1/#propdef-clip",
      "initial": "auto",
      "appliesTo": "Absolutely positioned elements. In SVG, it applies to elements which establish a new viewport, pattern elements and mask elements.",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value",
      "media": "visual",
      "styleDeclaration": [
        "clip"
      ],
      "syntax": "<rect()> | auto",
      "extended": []
    }
  ],
  [
    "color",
    {
      "name": "color",
      "href": "https://drafts.csswg.org/css-color-4/#propdef-color",
      "initial": "CanvasText",
      "appliesTo": "all elements and text",
      "inherited": "yes",
      "percentages": "N/A",
      "computedValue": "computed color, see resolving color values",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "styleDeclaration": [
        "color"
      ],
      "syntax": "<color>",
      "extended": []
    }
  ],
  [
    "display",
    {
      "name": "display",
      "href": "https://drafts.csswg.org/css-display-4/#propdef-display",
      "initial": "inline",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "a pair of keywords representing the inner and outer display types plus optional list-item flag, or a <display-internal> or <display-box> keyword; see prose in a variety of specs for computation rules",
      "canonicalOrder": "per grammar",
      "animationType": "see § 2.9 Animating and Interpolating display",
      "styleDeclaration": [
        "display"
      ],
      "syntax": "[ <display-outside> || <display-inside> ] | <display-listitem> | <display-internal> | <display-box> | <display-legacy> | <display-outside> || [ <display-inside> | math ]",
      "extended": [
        "https://w3c.github.io/mathml-core/"
      ]
    }
  ],
  [
    "flex",
    {
      "name": "flex",
      "href": "https://drafts.csswg.org/css-flexbox-1/#propdef-flex",
      "initial": "0 1 auto",
      "appliesTo": "flex items",
      "inherited": "no",
      "percentages": "see individual properties",
      "computedValue": "see individual properties",
      "animationType": "by computed value type",
      "canonicalOrder": "per grammar",
      "styleDeclaration": [
        "flex"
      ],
      "syntax": "none | [ <'flex-grow'> <'flex-shrink'>? || <'flex-basis'> ]",
      "extended": []
    }
  ],
  [
    "flex-basis",
    {
      "name": "flex-basis",
      "href": "https://drafts.csswg.org/css-flexbox-1/#propdef-flex-basis",
      "initial": "auto",
      "appliesTo": "flex items",
      "inherited": "no",
      "percentages": "relative to the flex container’s inner main size",
      "computedValue": "specified keyword or a computed <length-percentage> value",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "styleDeclaration": [
        "flex-basis",
        "flexBasis"
      ],
      "syntax": "content | <'width'>",
      "extended": []
    }
  ],
  [
    "flex-grow",
    {
      "name": "flex-grow",
      "href": "https://drafts.csswg.org/css-flexbox-1/#propdef-flex-grow",
      "initial": "0",
      "appliesTo": "flex items",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "specified number",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "styleDeclaration": [
        "flex-grow",
        "flexGrow"
      ],
      "syntax": "<number [0,∞]>",
      "extended": []
    }
  ],
  [
    "flex-shrink",
    {
      "name": "flex-shrink",
      "href": "https://drafts.csswg.org/css-flexbox-1/#propdef-flex-shrink",
      "initial": "1",
      "appliesTo": "flex items",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "specified value",
      "canonicalOrder": "per grammar",
      "animationType": "number",
      "styleDeclaration": [
        "flex-shrink",
        "flexShrink"
      ],
      "syntax": "<number [0,∞]>",
      "extended": []
    }
  ],
  [
    "float",
    {
      "name": "float",
      "href": "https://drafts.csswg.org/css-page-floats-3/#propdef-float",
      "initial": "none",
      "appliesTo": "all elements.",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "styleDeclaration": [
        "float"
      ],
      "syntax": "block-start | block-end | inline-start | inline-end | snap-block | <snap-block()> | snap-inline | <snap-inline()> | left | right | top | bottom | none | footnote",
      "extended": [
        "https://drafts.csswg.org/css-gcpm-3/"
      ]
    }
  ],
  [
    "flood-color",
    {
      "name": "flood-color",
      "href": "https://drafts.fxtf.org/filter-effects-1/#propdef-flood-color",
      "initial": "black",
      "appliesTo": "feFlood and feDropShadow elements",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value",
      "media": "visual",
      "styleDeclaration": [
        "flood-color",
        "floodColor"
      ],
      "syntax": "<color>",
      "extended": []
    }
  ],
  [
    "font",
    {
      "name": "font",
      "href": "https://drafts.csswg.org/css-fonts-4/#propdef-font",
      "initial": "see individual properties",
      "appliesTo": "all elements and text",
      "inherited": "yes",
      "percentages": "see individual properties",
      "computedValue": "see individual properties",
      "canonicalOrder": "per grammar",
      "animationType": "see individual properties",
      "styleDeclaration": [
        "font"
      ],
      "syntax": "[ [ <'font-style'> || <font-variant-css2> || <'font-weight'> || <font-width-css3> ]? <'font-size'> [ / <'line-height'> ]? <'font-family'># ] | <system-family-name>",
      "extended": []
    }
  ],
  [
    "font-family",
    {
      "name": "font-family",
      "href": "https://drafts.csswg.org/css-fonts-4/#propdef-font-family",
      "initial": "depends on user agent",
      "appliesTo": "all elements and text",
      "inherited": "yes",
      "percentages": "n/a",
      "computedValue": "list, each item a string and/or <generic-family> keywords",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "font-family",
        "fontFamily"
      ],
      "syntax": "[ <family-name> | <generic-family> ]#",
      "extended": []
    }
  ],
  [
    "font-size",
    {
      "name": "font-size",
      "href": "https://drafts.csswg.org/css-fonts-4/#propdef-font-size",
      "initial": "medium",
      "appliesTo": "all elements and text",
      "inherited": "yes",
      "percentages": "refer to parent element’s font size",
      "computedValue": "an absolute length",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "styleDeclaration": [
        "font-size",
        "fontSize"
      ],
      "syntax": "<absolute-size> | <relative-size> | <length-percentage [0,∞]> | math",
      "extended": []
    }
  ],
  [
    "font-style",
    {
      "name": "font-style",
      "href": "https://drafts.csswg.org/css-fonts-4/#propdef-font-style",
      "initial": "normal",
      "appliesTo": "all elements and text",
      "inherited": "yes",
      "percentages": "n/a",
      "computedValue": "the keyword specified, plus angle in degrees if specified",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type;normal animates as oblique 0deg",
      "styleDeclaration": [
        "font-style",
        "fontStyle"
      ],
      "syntax": "normal | italic | left | right | oblique <angle [-90deg,90deg]>?",
      "extended": []
    }
  ],
  [
    "font-variant",
    {
      "name": "font-variant",
      "href": "https://drafts.csswg.org/css-fonts-4/#propdef-font-variant",
      "initial": "normal",
      "appliesTo": "all elements and text",
      "inherited": "yes",
      "percentages": "n/a",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "animationType": "discrete",
      "styleDeclaration": [
        "font-variant",
        "fontVariant"
      ],
      "syntax": "normal | none | [ [ <common-lig-values> || <discretionary-lig-values> || <historical-lig-values> || <contextual-alt-values> ] || [ small-caps | all-small-caps | petite-caps | all-petite-caps | unicase | titling-caps ] || [ stylistic(<feature-value-name>) || historical-forms || styleset(<feature-value-name>#) || character-variant(<feature-value-name>#) || swash(<feature-value-name>) || ornaments(<feature-value-name>) || annotation(<feature-value-name>) ] || [ <numeric-figure-values> || <numeric-spacing-values> || <numeric-fraction-values> || ordinal || slashed-zero ] || [ <east-asian-variant-values> || <east-asian-width-values> || ruby ] || [ sub | super ] || [ text | emoji | unicode ] ]",
      "extended": []
    }
  ],
  [
    "font-weight",
    {
      "name": "font-weight",
      "href": "https://drafts.csswg.org/css-fonts-4/#propdef-font-weight",
      "initial": "normal",
      "appliesTo": "all elements and text",
      "inherited": "yes",
      "percentages": "n/a",
      "computedValue": "a number, see below",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "styleDeclaration": [
        "font-weight",
        "fontWeight"
      ],
      "syntax": "<font-weight-absolute> | bolder | lighter",
      "extended": []
    }
  ],
  [
    "height",
    {
      "name": "height",
      "href": "https://drafts.csswg.org/css-sizing-3/#propdef-height",
      "initial": "auto",
      "appliesTo": "all elements except non-replaced inlines",
      "inherited": "no",
      "percentages": "relative to width/height of containing block",
      "computedValue": "as specified, with <length-percentage> values computed",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type, recursing into fit-content()",
      "logicalPropertyGroup": "size",
      "styleDeclaration": [
        "height"
      ],
      "syntax": "auto | <length-percentage [0,∞]> | min-content | max-content | fit-content(<length-percentage [0,∞]>) | <calc-size()> | <anchor-size()> | stretch | fit-content | contain",
      "extended": [
        "https://drafts.csswg.org/css-anchor-position-1/",
        "https://drafts.csswg.org/css-sizing-4/"
      ]
    }
  ],
  [
    "left",
    {
      "name": "left",
      "href": "https://drafts.csswg.org/css-position-3/#propdef-left",
      "initial": "auto",
      "appliesTo": "positioned elements",
      "inherited": "no",
      "percentages": "refer to size of containing block; see prose",
      "computedValue": "the keyword auto or a computed <length-percentage> value",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "logicalPropertyGroup": "inset",
      "styleDeclaration": [
        "left"
      ],
      "syntax": "auto | <length-percentage> | <anchor()> | <anchor-size()>",
      "extended": [
        "https://drafts.csswg.org/css-anchor-position-1/"
      ]
    }
  ],
  [
    "lighting-color",
    {
      "name": "lighting-color",
      "href": "https://drafts.fxtf.org/filter-effects-1/#propdef-lighting-color",
      "initial": "white",
      "appliesTo": "feDiffuseLighting and feSpecularLighting elements",
      "inherited": "no",
      "percentages": "n/a",
      "computedValue": "as specified",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value",
      "media": "visual",
      "styleDeclaration": [
        "lighting-color",
        "lightingColor"
      ],
      "syntax": "<color>",
      "extended": []
    }
  ],
  [
    "line-height",
    {
      "name": "line-height",
      "href": "https://drafts.csswg.org/css-inline-3/#propdef-line-height",
      "initial": "normal",
      "appliesTo": "non-replaced inline boxes and SVG text content elements",
      "inherited": "yes",
      "percentages": "computed relative to 1em",
      "computedValue": "the specified keyword, a number, or a computed <length> value",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "styleDeclaration": [
        "line-height",
        "lineHeight"
      ],
      "syntax": "normal | <number [0,∞]> | <length-percentage [0,∞]>",
      "extended": []
    }
  ],
  [
    "margin",
    {
      "name": "margin",
      "href": "https://drafts.csswg.org/css-box-4/#propdef-margin",
      "initial": "0",
      "appliesTo": "all elements except internal table elements, ruby base containers, and ruby annotation containers",
      "inherited": "no",
      "percentages": "refer to logical width of containing block",
      "computedValue": "see individual properties",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "styleDeclaration": [
        "margin"
      ],
      "syntax": "<'margin-top'>{1,4}",
      "extended": []
    }
  ],
  [
    "margin-bottom",
    {
      "name": "margin-bottom",
      "href": "https://drafts.csswg.org/css-box-4/#propdef-margin-bottom",
      "initial": "0",
      "appliesTo": "all elements except internal table elements, ruby base containers, and ruby annotation containers",
      "inherited": "no",
      "percentages": "refer to logical width of containing block",
      "computedValue": "the keyword auto or a computed <length-percentage> value",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "logicalPropertyGroup": "margin",
      "styleDeclaration": [
        "margin-bottom",
        "marginBottom"
      ],
      "syntax": "<length-percentage> | auto | <anchor-size()>",
      "extended": [
        "https://drafts.csswg.org/css-anchor-position-1/"
      ]
    }
  ],
  [
    "margin-left",
    {
      "name": "margin-left",
      "href": "https://drafts.csswg.org/css-box-4/#propdef-margin-left",
      "initial": "0",
      "appliesTo": "all elements except internal table elements, ruby base containers, and ruby annotation containers",
      "inherited": "no",
      "percentages": "refer to logical width of containing block",
      "computedValue": "the keyword auto or a computed <length-percentage> value",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "logicalPropertyGroup": "margin",
      "styleDeclaration": [
        "margin-left",
        "marginLeft"
      ],
      "syntax": "<length-percentage> | auto | <anchor-size()>",
      "extended": [
        "https://drafts.csswg.org/css-anchor-position-1/"
      ]
    }
  ],
  [
    "margin-right",
    {
      "name": "margin-right",
      "href": "https://drafts.csswg.org/css-box-4/#propdef-margin-right",
      "initial": "0",
      "appliesTo": "all elements except internal table elements, ruby base containers, and ruby annotation containers",
      "inherited": "no",
      "percentages": "refer to logical width of containing block",
      "computedValue": "the keyword auto or a computed <length-percentage> value",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "logicalPropertyGroup": "margin",
      "styleDeclaration": [
        "margin-right",
        "marginRight"
      ],
      "syntax": "<length-percentage> | auto | <anchor-size()>",
      "extended": [
        "https://drafts.csswg.org/css-anchor-position-1/"
      ]
    }
  ],
  [
    "margin-top",
    {
      "name": "margin-top",
      "href": "https://drafts.csswg.org/css-box-4/#propdef-margin-top",
      "initial": "0",
      "appliesTo": "all elements except internal table elements, ruby base containers, and ruby annotation containers",
      "inherited": "no",
      "percentages": "refer to logical width of containing block",
      "computedValue": "the keyword auto or a computed <length-percentage> value",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "logicalPropertyGroup": "margin",
      "styleDeclaration": [
        "margin-top",
        "marginTop"
      ],
      "syntax": "<length-percentage> | auto | <anchor-size()>",
      "extended": [
        "https://drafts.csswg.org/css-anchor-position-1/"
      ]
    }
  ],
  [
    "opacity",
    {
      "name": "opacity",
      "href": "https://drafts.csswg.org/css-color-4/#propdef-opacity",
      "initial": "1",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "map to the range [0,1]",
      "computedValue": "specified number, clamped to the range [0,1]",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "styleDeclaration": [
        "opacity"
      ],
      "syntax": "<opacity-value>",
      "extended": []
    }
  ],
  [
    "outline-color",
    {
      "name": "outline-color",
      "href": "https://drafts.csswg.org/css-ui-4/#propdef-outline-color",
      "initial": "auto",
      "appliesTo": "all elements",
      "inherited": "no",
      "percentages": "N/A",
      "computedValue": "see below",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value",
      "styleDeclaration": [
        "outline-color",
        "outlineColor"
      ],
      "syntax": "auto | <'border-top-color'>",
      "extended": []
    }
  ],
  [
    "padding",
    {
      "name": "padding",
      "href": "https://drafts.csswg.org/css-box-4/#propdef-padding",
      "initial": "0",
      "appliesTo": "all elements except: internal table elements other than table cells, ruby base containers, and ruby annotation containers",
      "inherited": "no",
      "percentages": "refer to logical width of containing block",
      "computedValue": "see individual properties",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "styleDeclaration": [
        "padding"
      ],
      "syntax": "<'padding-top'>{1,4}",
      "extended": []
    }
  ],
  [
    "padding-bottom",
    {
      "name": "padding-bottom",
      "href": "https://drafts.csswg.org/css-box-4/#propdef-padding-bottom",
      "initial": "0",
      "appliesTo": "all elements except: internal table elements other than table cells, ruby base containers, and ruby annotation containers",
      "inherited": "no",
      "percentages": "refer to logical width of containing block",
      "computedValue": "a computed <length-percentage> value",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "logicalPropertyGroup": "padding",
      "styleDeclaration": [
        "padding-bottom",
        "paddingBottom"
      ],
      "syntax": "<length-percentage [0,∞]>",
      "extended": []
    }
  ],
  [
    "padding-left",
    {
      "name": "padding-left",
      "href": "https://drafts.csswg.org/css-box-4/#propdef-padding-left",
      "initial": "0",
      "appliesTo": "all elements except: internal table elements other than table cells, ruby base containers, and ruby annotation containers",
      "inherited": "no",
      "percentages": "refer to logical width of containing block",
      "computedValue": "a computed <length-percentage> value",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "logicalPropertyGroup": "padding",
      "styleDeclaration": [
        "padding-left",
        "paddingLeft"
      ],
      "syntax": "<length-percentage [0,∞]>",
      "extended": []
    }
  ],
  [
    "padding-right",
    {
      "name": "padding-right",
      "href": "https://drafts.csswg.org/css-box-4/#propdef-padding-right",
      "initial": "0",
      "appliesTo": "all elements except: internal table elements other than table cells, ruby base containers, and ruby annotation containers",
      "inherited": "no",
      "percentages": "refer to logical width of containing block",
      "computedValue": "a computed <length-percentage> value",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "logicalPropertyGroup": "padding",
      "styleDeclaration": [
        "padding-right",
        "paddingRight"
      ],
      "syntax": "<length-percentage [0,∞]>",
      "extended": []
    }
  ],
  [
    "padding-top",
    {
      "name": "padding-top",
      "href": "https://drafts.csswg.org/css-box-4/#propdef-padding-top",
      "initial": "0",
      "appliesTo": "all elements except: internal table elements other than table cells, ruby base containers, and ruby annotation containers",
      "inherited": "no",
      "percentages": "refer to logical width of containing block",
      "computedValue": "a computed <length-percentage> value",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "logicalPropertyGroup": "padding",
      "styleDeclaration": [
        "padding-top",
        "paddingTop"
      ],
      "syntax": "<length-percentage [0,∞]>",
      "extended": []
    }
  ],
  [
    "right",
    {
      "name": "right",
      "href": "https://drafts.csswg.org/css-position-3/#propdef-right",
      "initial": "auto",
      "appliesTo": "positioned elements",
      "inherited": "no",
      "percentages": "refer to size of containing block; see prose",
      "computedValue": "the keyword auto or a computed <length-percentage> value",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "logicalPropertyGroup": "inset",
      "styleDeclaration": [
        "right"
      ],
      "syntax": "auto | <length-percentage> | <anchor()> | <anchor-size()>",
      "extended": [
        "https://drafts.csswg.org/css-anchor-position-1/"
      ]
    }
  ],
  [
    "stop-color",
    {
      "name": "stop-color",
      "href": "https://svgwg.org/svg2-draft/pservers.html#StopColorProperty",
      "styleDeclaration": [
        "stop-color",
        "stopColor"
      ],
      "extended": []
    }
  ],
  [
    "top",
    {
      "name": "top",
      "href": "https://drafts.csswg.org/css-position-3/#propdef-top",
      "initial": "auto",
      "appliesTo": "positioned elements",
      "inherited": "no",
      "percentages": "refer to size of containing block; see prose",
      "computedValue": "the keyword auto or a computed <length-percentage> value",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type",
      "logicalPropertyGroup": "inset",
      "styleDeclaration": [
        "top"
      ],
      "syntax": "auto | <length-percentage> | <anchor()> | <anchor-size()>",
      "extended": [
        "https://drafts.csswg.org/css-anchor-position-1/"
      ]
    }
  ],
  [
    "width",
    {
      "name": "width",
      "href": "https://drafts.csswg.org/css-sizing-3/#propdef-width",
      "initial": "auto",
      "appliesTo": "all elements except non-replaced inlines",
      "inherited": "no",
      "percentages": "relative to width/height of containing block",
      "computedValue": "as specified, with <length-percentage> values computed",
      "canonicalOrder": "per grammar",
      "animationType": "by computed value type, recursing into fit-content()",
      "logicalPropertyGroup": "size",
      "styleDeclaration": [
        "width"
      ],
      "syntax": "auto | <length-percentage [0,∞]> | min-content | max-content | fit-content(<length-percentage [0,∞]>) | <calc-size()> | <anchor-size()> | stretch | fit-content | contain",
      "extended": [
        "https://drafts.csswg.org/css-anchor-position-1/",
        "https://drafts.csswg.org/css-sizing-4/"
      ]
    }
  ]
]);
