import React from 'react'
import { render, screen } from '@testing-library/react'
import userEvent from '@testing-library/user-event'
import { describe, expect, it, vi } from 'vitest'

import ConfigPanel from './ConfigPanel'
import { DEFAULT_PLAYER_CONFIG } from '../types/playerConfig'

describe('ConfigPanel', () => {
  it('updates url input', async () => {
    const onChange = vi.fn()
    const user = userEvent.setup()

    render(<ConfigPanel config={DEFAULT_PLAYER_CONFIG} onChange={onChange} />)

    const input = screen.getByLabelText(/m3u8 url/i)
    await user.type(input, 'https://example.com/stream.m3u8')
    await new Promise((resolve) => setTimeout(resolve, 700))

    expect(onChange).toHaveBeenCalled()
  })

  it('toggles proxy flag', async () => {
    const onChange = vi.fn()
    const user = userEvent.setup()

    render(<ConfigPanel config={DEFAULT_PLAYER_CONFIG} onChange={onChange} />)

    const refine = screen.getByRole('button', { name: /refine/i })
    await user.click(refine)

    const toggle = screen.getByRole('checkbox', { name: /use cors proxy/i })
    await user.click(toggle)

    expect(onChange).toHaveBeenCalled()
    const lastCall = onChange.mock.calls.at(-1)?.[0]
    expect(lastCall.proxy).toBe(true)
  })
})
