import type { PlayerConfig } from '../types/playerConfig'
import type { HlsStatus } from '../lib/hlsController'
import InputWorkspace from './InputWorkspace'

interface ConfigPanelProps {
  config: PlayerConfig
  onChange: (config: PlayerConfig) => void
  status?: HlsStatus
}

function ConfigPanel({ config, onChange, status }: ConfigPanelProps) {
  return (
    <InputWorkspace
      config={config}
      onChange={onChange}
      status={status}
      showPublish={false}
    />
  )
}

export default ConfigPanel
