import type { CSSProperties } from 'react'
import type { PlayerConfig } from '../types/playerConfig'
import type { HlsStatus } from '../lib/hlsController'
import HlsPlayer from './HlsPlayer'

interface PreviewWellProps {
  config: PlayerConfig
  onStatusChange: (status: HlsStatus) => void
}

function PreviewWell({ config, onStatusChange }: PreviewWellProps) {
  const hasUrl = Boolean(config.url)

  return (
    <div className="preview-well reveal" style={{ '--delay': '0.1s' } as CSSProperties}>
      <div className="preview-header">
        <span>Preview Well</span>
        <span>Live</span>
      </div>

      <div className="preview-stage">
        <div className="preview-geometry">
          <span />
          <span />
          <span />
          <span />
        </div>

        {hasUrl ? (
          <div className="preview-frame">
            <HlsPlayer config={config} onStatusChange={onStatusChange} />
          </div>
        ) : (
          <div className="preview-placeholder">
            <strong>Ready to Stream</strong>
            <span>Paste an HLS manifest to light up the preview.</span>
          </div>
        )}
      </div>
    </div>
  )
}

export default PreviewWell
