interface StatusBannerProps {
  message: string
  tone?: 'info' | 'error'
}

function StatusBanner({ message, tone = 'info' }: StatusBannerProps) {
  const baseClasses = "px-4 py-2 rounded-full text-xs font-mono font-bold tracking-wide shadow-lg backdrop-blur-md pointer-events-auto"
  const toneClasses = tone === 'error' 
    ? "bg-red-500/10 text-red-500 border border-red-500/20" 
    : "bg-vn-red/10 text-vn-yellow border border-vn-red/20"
  
  return <div className={`${baseClasses} ${toneClasses}`}>{message}</div>
}

export default StatusBanner
