import type { ReactNode } from 'react'

interface StudioLayoutProps {
  left: ReactNode
  right: ReactNode
}

function StudioLayout({ left, right }: StudioLayoutProps) {
  return (
    <div className="studio-layout">
      <section className="studio-left">
        <div className="studio-left-inner">{left}</div>
      </section>
      <section className="studio-right">
        <div className="studio-right-inner">{right}</div>
      </section>
    </div>
  )
}

export default StudioLayout
