export type PreloadOption = 'auto' | 'metadata' | 'none'

export interface PlayerConfig {
  url: string
  autoplay: boolean
  muted: boolean
  loop: boolean
  poster: string
  controls: boolean
  preload: PreloadOption
  proxy: boolean
}

export const DEFAULT_PLAYER_CONFIG: PlayerConfig = {
  url: '',
  autoplay: false,
  muted: false,
  loop: false,
  poster: '',
  controls: true,
  preload: 'metadata',
  proxy: false,
}
