import { defineConfig } from 'vite'
import react from '@vitejs/plugin-react'

const frontendPort = Number(process.env.FRONTEND_PORT || 7594)
const frontendHost = process.env.FRONTEND_HOST || '0.0.0.0'
const allowedHosts = (process.env.FRONTEND_ALLOWED_HOSTS ||
  'm3u8.thinhkhuat.com,localhost,127.0.0.1,::1')
  .split(',')
  .map((host) => host.trim())
  .filter(Boolean)

// https://vite.dev/config/
export default defineConfig({
  plugins: [react()],
  server: {
    host: frontendHost,
    port: frontendPort,
    strictPort: true,
    allowedHosts,
  },
  preview: {
    host: frontendHost,
    port: frontendPort,
    strictPort: true,
    allowedHosts,
  },
})
