# Local VOD via Admin Shares + HLS Packaging + Hybrid VideoToolbox Packager

## Status
Under Review

## Authors
Droid (GPT-5.2) — 2026-01-21
Thinh Khuat (requirements/approval)

## Overview
Add a local VOD feature with **admin-only browse/register**, **expiring share tokens**, reliable `.ts` playback via HLS packaging, and an optional **macOS VideoToolbox** host packager. External `http(s)://…m3u8` playback and embed export remain unchanged.

## Background / Problem Statement
Browsers need HTTP-accessible media. Exposing direct filesystem paths is unsafe and leaks host details. We need a controlled, tokenized sharing flow with time-limited access and consistent playback for `.ts` inputs.

## Goals
- Admin-only browsing/registration of files within a configured media root.
- Expiring share tokens with configurable TTL (via admin UI).
- Tokenized playback URLs (no filesystem paths in URLs/embeds).
- `.ts` reliability via on-demand HLS packaging (copy-first, fallback to H.264/AAC).
- Optional hybrid packager on macOS using VideoToolbox.
- Works with **Docker** or **non-Docker** setups.

## Non-Goals
- Live ingest (RTMP/RTSP/SRT/WebRTC).
- ABR ladders and multi-bitrate HLS.
- Multi-user auth beyond a single admin login.

## Technical Dependencies
- Backend: Express + Node ESM (existing).
- Frontend: React/Vite (existing).
- External: `ffmpeg` + `ffprobe`.
- Hybrid: macOS host ffmpeg with `h264_videotoolbox`.

## Detailed Design

### Data flow
1. Admin logs in.
2. Admin browses and selects a local file (relative path).
3. Admin sets TTL and creates a share.
4. Backend returns a token: `localhls:<id>` or `localfile:<id>`.
5. Player uses token to stream; share expires at TTL.

### Storage
- `/data/local-shares.json` stores `shareId -> { path, kind, createdAt, expiresAt }`.

### Backend API
**Admin Auth**
- `POST /admin/login` → session cookie
- `POST /admin/logout`
- `GET /admin/me`

**Local Browse + Shares** (admin-only)
- `GET /local/browse?dir=...`
- `POST /local/shares { path, ttlSeconds }`
- `GET /local/shares`
- `DELETE /local/shares/:id`

**Public Playback**
- `GET /local/share/file/:id` (Range)
- `GET /local/share/hls/:id/index.m3u8`
- `GET /local/share/hls/:id/:asset`

### HLS packaging (A+)
- Copy-first HLS packaging for `.ts`.
- If copy fails, fallback to **H.264/AAC**.
- Cache output in `/data/hls-cache/<shareId>/`.

### Hybrid VideoToolbox packager
- Host packager receives `{ shareId, relPath, target }`.
- Writes HLS outputs into shared data dir.
- Protected by bearer token.

### Frontend UX
- Local VOD panel with login, browse, TTL, share creation, share list + revoke.
- `SOURCE_URL` shows relative path for local shares but stores token internally.

## Testing Strategy
- Backend unit tests for auth, share TTL, browse, range handling, and playlist rewriting.
- Frontend tests for token parsing and admin UI flows.
- Tests include purpose comments.

## Performance Considerations
- Cache HLS outputs; limit concurrent ffmpeg jobs.

## Security Considerations
- Admin-only browse/register.
- Strict relative path handling with realpath containment.
- Share tokens are unguessable and expire.
- Packager calls authenticated.

## Implementation Phases
1. Backend core + share persistence.
2. HLS packaging + cache.
3. Frontend admin UI + playback token handling.
4. Hybrid packager + Docker wiring.

## References
- `backend/proxy.js` playlist rewrite patterns.
- `hls-player/src/lib/hlsController.ts` for playback behavior.
